<?php
/**
 * @copyright	Copyright (C) 2009-2015 ACYBA SAS - All rights reserved..
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */
defined('_JEXEC') or die('Restricted access');

class plgAcymailingAkeebasub extends JPlugin
{
	function plgAcymailingAkeebasub(&$subject, $config){
		parent::__construct($subject, $config);
	}

	function onAcyDisplayFilters(&$type){
		$type['akeebasub'] = JText::_('COM_AKEEBASUBS');
		$acyconfig = acymailing_config();
		if(version_compare($acyconfig->get('version'),'4.9.3','<')) return '<div id="filter__num__akeebasub">Please update AcyMailing, the Akeeba plugin may not work properly with this version</div>';

		$db = JFactory::getDBO();
		$db->setQuery('SELECT akeebasubs_level_id, title FROM #__akeebasubs_levels ORDER BY title ASC');
		$allLevels = (array) $db->loadObjectList();
		$levels = array();
		$levels[] = JHTML::_('select.option', 0, '- - -');
		foreach($allLevels as $oneLevel){
			$levels[] = JHTML::_('select.option', $oneLevel->akeebasubs_level_id, $oneLevel->title);
		}

		$lang = JFactory::getLanguage();
		$lang->load('com_akeebasubs',JPATH_ADMINISTRATOR);

		$status = array();
		$status[] = JHTML::_('select.option', '0','- - -');
		$status[] = JHTML::_('select.option', 'N', JText::_('COM_AKEEBASUBS_SUBSCRIPTION_STATE_N'));
		$status[] = JHTML::_('select.option', 'P', JText::_('COM_AKEEBASUBS_SUBSCRIPTION_STATE_P'));
		$status[] = JHTML::_('select.option', 'C', JText::_('COM_AKEEBASUBS_SUBSCRIPTION_STATE_C'));
		$status[] = JHTML::_('select.option', 'X', JText::_('COM_AKEEBASUBS_SUBSCRIPTION_STATE_X'));

		$return = '<div id="filter__num__akeebasub">';
		$return .= JHTML::_('select.genericlist', $levels, 'filter[__num__][akeebasub][levelid]', 'class="inputbox" onchange="countresults(__num__)" size="1"', 'value', 'text');
		$return .= JHTML::_('select.genericlist', $status, 'filter[__num__][akeebasub][substate]', 'class="inputbox" onchange="countresults(__num__)" size="1"', 'value', 'text');
		$return .= '<br /> <input type="text" name="filter[__num__][akeebasub][cdateinf]" onclick="displayDatePicker(this,event)" onchange="countresults(__num__)" style="width:100px" /> < '.JText::_('COM_AKEEBASUBS_SUBSCRIPTION_PUBLISH_UP').' < <input type="text" name="filter[__num__][akeebasub][cdatesup]" onclick="displayDatePicker(this,event)" onchange="countresults(__num__)" style="width:100px" />';
		$return .= '<br /> <input type="text" name="filter[__num__][akeebasub][mdateinf]" onclick="displayDatePicker(this,event)" onchange="countresults(__num__)" style="width:100px" /> < '.JText::_('COM_AKEEBASUBS_SUBSCRIPTION_PUBLISH_DOWN').' < <input type="text" name="filter[__num__][akeebasub][mdatesup]" onclick="displayDatePicker(this,event)" onchange="countresults(__num__)" style="width:100px" />';
		$return .= '</div>';

		return $return;
	}

	function onAcyProcessFilterCount_akeebasub(&$query,$filter,$num){
		$this->onAcyProcessFilter_akeebasub($query,$filter,$num);
		return JText::sprintf('SELECTED_USERS',$query->count());
	}

	function onAcyProcessFilter_akeebasub(&$query,$filter,$num){
		$myquery = 'SELECT DISTINCT b.email FROM #__akeebasubs_subscriptions AS a JOIN #__users AS b ON a.user_id = b.id ';
		$where = array();
		if(!empty($filter['levelid'])) $where[] = 'a.akeebasubs_level_id = '.intval($filter['levelid']);
		if(!empty($filter['substate'])) $where[] = 'a.state = '.$query->db->quote($filter['substate']);
	 	if(!empty($filter['cdateinf'])){
	 		$filter['cdateinf'] = acymailing_replaceDate($filter['cdateinf']);
	 		if(!is_numeric($filter['cdateinf'])) $filter['cdateinf'] = strtotime($filter['cdateinf']);
	 		if(is_numeric($filter['cdateinf'])) $filter['cdateinf'] = strftime('%Y-%m-%d %H:%M:%S',$filter['cdateinf']);
		 	$where[] = 'a.publish_up > '.$query->db->Quote($filter['cdateinf']);
	 	}

	 	if(!empty($filter['cdatesup'])){
	 		$filter['cdatesup'] = acymailing_replaceDate($filter['cdatesup']);
	 		if(!is_numeric($filter['cdatesup'])) $filter['cdatesup'] = strtotime($filter['cdatesup']);
	 		if(is_numeric($filter['cdatesup'])) $filter['cdatesup'] = strftime('%Y-%m-%d %H:%M:%S',$filter['cdatesup']);
		 	$where[] = 'a.publish_up < '.$query->db->Quote($filter['cdatesup']);
	 	}

	 	if(!empty($filter['mdateinf'])){
	 		$filter['mdateinf'] = acymailing_replaceDate($filter['mdateinf']);
	 		if(!is_numeric($filter['mdateinf'])) $filter['mdateinf'] = strtotime($filter['mdateinf']);
	 		if(is_numeric($filter['mdateinf'])) $filter['mdateinf'] = strftime('%Y-%m-%d %H:%M:%S',$filter['mdateinf']);
		 	$where[] = 'a.publish_down > '.$query->db->Quote($filter['mdateinf']);
	 	}

	 	if(!empty($filter['mdatesup'])){
	 		$filter['mdatesup'] = acymailing_replaceDate($filter['mdatesup']);
	 		if(!is_numeric($filter['mdatesup'])) $filter['mdatesup'] = strtotime($filter['mdatesup']);
	 		if(is_numeric($filter['mdatesup'])) $filter['mdatesup'] = strftime('%Y-%m-%d %H:%M:%S',$filter['mdatesup']);
		 	$where[] = 'a.publish_down < '.$query->db->Quote($filter['mdatesup']);
	 	}
		if(!empty($where)) $myquery .= 'WHERE ('.implode(')AND(', $where).')';
		$query->db->setQuery($myquery);
		$allEmails  = acymailing_loadResultArray($query->db);
		if(empty($allEmails)) $allEmails[] = 'none';
		$query->where[] = "sub.email IN ('".implode("','",$allEmails)."')";
	}
}//endclass